<?php
// Check if an ID parameter is provided for editing
if (isset($_GET['id'])) {
    $data_id = $_GET['id'];

    // Retrieve the data item with the provided ID and populate the form fields
    $data = cfm_get_data_by_id($data_id); // Replace this with your own code to fetch the data by ID

    // Check if the data exists
    if ($data) {
        $name = $data['name'];
        $label = $data['label'];
        $type = $data['type'];
        $action = 'edit';
    } else {
        // Data not found, redirect back to the existing data table
        wp_safe_redirect(admin_url('admin.php?page=custom-fields-manager'));
        exit;
    }
} else {
    $action = 'add';
    $name = "";
    $label = "";
    $type = "";
}

?>

<h2><?php echo esc_html__('Data Form', 'custom-fields-manager'); ?></h2>

<form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
    <input type="hidden" name="action" value="custom_fields_manager_save_data">
    <?php if ($action === 'edit') : ?>
        <input type="hidden" name="id" value="<?php echo esc_attr($data_id); ?>">
    <?php endif; ?>

    <div class="cfm-form-field">
        <label for="field-name"><?php echo esc_html__('Name', 'custom-fields-manager'); ?>:</label>
        <input type="text" id="field-name" name="cfm_name" value="<?php echo esc_attr($name); ?>">
    </div>

    <div class="cfm-form-field">
        <label for="field-label"><?php echo esc_html__('Label', 'custom-fields-manager'); ?>:</label>
        <input type="text" id="field-label" name="cfm_label" value="<?php echo esc_attr($label); ?>">
    </div>

    <div class="cfm-form-field">
        <label for="field-type"><?php echo esc_html__('Type', 'custom-fields-manager'); ?>:</label>
        <select id="field-type" name="cfm_type">
            <option value="text" <?php selected($type, 'text'); ?>><?php echo esc_html__('Text', 'custom-fields-manager'); ?></option>
            <option value="textarea" <?php selected($type, 'textarea'); ?>><?php echo esc_html__('Textarea', 'custom-fields-manager'); ?></option>
            <option value="post-category" <?php selected($type, 'post-category'); ?>><?php echo esc_html__('Post Category', 'custom-fields-manager'); ?></option>
        </select>
    </div>

    <input type="submit" name="cfm_submit" value="<?php echo esc_attr__($action === 'edit' ? 'Update' : 'Save', 'custom-fields-manager'); ?>" class="button button-primary">
    <?php if ($action === 'edit') : ?>
        <a href="<?php echo esc_url(add_query_arg(array('action' => 'delete', 'id' => $data_id), admin_url('admin.php?page=custom-fields-manager'))); ?>" class="button button-secondary cfm-delete-button"><?php echo esc_html__('Delete', 'custom-fields-manager'); ?></a>
    <?php endif; ?>
    <a href="<?php echo esc_url(admin_url('admin.php?page=custom-fields-manager')); ?>" class="button button-cancel"><?php echo esc_html__('Cancel', 'custom-fields-manager'); ?></a>
</form>