<?php
// Retrieve and process the existing data
$existing_data = cfm_get_existing_data(); // Replace this with your own code to fetch the existing data

?>

<div class="cfm-header-section">
    <h2><?php echo esc_html__('Existing Data', 'custom-fields-manager'); ?></h2>

    <div class="cfm-add-btn">
        <a class="cfm-add-button" href="<?php echo esc_url(admin_url('admin.php?page=custom-fields-manager&action=add')); ?>"><?php echo esc_html__('Add New', 'custom-fields-manager'); ?></a>
    </div>
</div>

<table class="wp-list-table widefat striped">
    <thead>
        <tr>
            <th><?php echo esc_html__('Name', 'custom-fields-manager'); ?></th>
            <th><?php echo esc_html__('Label', 'custom-fields-manager'); ?></th>
            <th><?php echo esc_html__('Type', 'custom-fields-manager'); ?></th>
            <th><?php echo esc_html__('Actions', 'custom-fields-manager'); ?></th>
        </tr>
    </thead>
    <tbody>
        <?php if ($existing_data['items']) : ?>
            <?php foreach ($existing_data['items'] as $data) : ?>
                <tr>
                    <td><?php echo esc_html($data['name']); ?></td>
                    <td><?php echo esc_html($data['label']); ?></td>
                    <td><?php echo esc_html($data['type']); ?></td>
                    <td class="cfm-action-wrapper">
                        <div class="cfm-action-container">
                            <a class="cfm-edit-button" href="<?php echo esc_url(add_query_arg(array('action' => 'edit', 'id' => $data['id']), admin_url('admin.php?page=custom-fields-manager'))); ?>"><?php echo esc_html__('Edit', 'custom-fields-manager'); ?></a>
                            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
                                <input type="hidden" name="action" value="custom_fields_manager_delete_data">
                                <input type="hidden" name="id" value="<?php echo esc_attr($data['id']); ?>">
                                <?php wp_nonce_field('custom_fields_manager_delete_data', 'custom_fields_manager_delete_data_nonce'); ?>
                                <button type="submit" name="cfm_delete" class="button button-danger cfm-delete-button"><?php echo esc_html__('Delete', 'custom-fields-manager'); ?></button>
                            </form>
                        </div>
                    </td>
                </tr>
            <?php endforeach; ?>
        <?php else : ?>
            <tr>
                <td colspan="4"><?php echo esc_html__('No existing data found.', 'custom-fields-manager'); ?></td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>