<?php

function custom_fields_manager_add_meta_box()
{
    add_meta_box(
        'custom_fields_manager',              // Unique ID for the meta box
        'Custom Fields Manager Data',                 // Title of the meta box
        'custom_fields_manager_meta_box_callback',     // Callback function to render the meta box
        'post',                         // Post type (e.g., 'post' for posts, 'page' for pages)
        'normal',                       // Position within the editor (e.g., 'normal', 'side', 'advanced')
        'default'                       // Priority of the meta box (e.g., 'high', 'low')
    );
    add_meta_box(
        'custom_fields_manager',              // Unique ID for the meta box
        'Custom Fields Manager Data',                 // Title of the meta box
        'custom_fields_manager_meta_box_callback',     // Callback function to render the meta box
        'page',                         // Post type (e.g., 'post' for posts, 'page' for pages)
        'normal',                       // Position within the editor (e.g., 'normal', 'side', 'advanced')
        'default'                       // Priority of the meta box (e.g., 'high', 'low')
    );
}
add_action('add_meta_boxes', 'custom_fields_manager_add_meta_box');

function cfm_get_field_name($name)
{
    return CUSTOM_FIELDS_MANAGER_PREFIX . $name;
}
function cfm_get_field_value($name, $post_id = "")
{
    if ($post_id) {
    } else {
        $post_id = get_the_ID();
    }
    $serialized_data = unserialize(get_post_meta($post_id, 'custom_fields_manager', true));
    if (isset($serialized_data[$name])) {
        return urldecode($serialized_data[$name]);
    } else {
        return "";
    }
}
function cfm_set_field_value($name, $value, $post_id = "")
{
    if ($post_id) {
    } else {
        $post_id = get_the_ID();
    }
    $customSaveData = unserialize(get_post_meta($post_id, 'custom_fields_manager', true));
    $customSaveData[$name] = $value;
    $serialized_data = serialize($customSaveData);
    update_post_meta($post_id, 'custom_fields_manager', $serialized_data);
}
function custom_fields_manager_meta_box_callback($post)
{
    $existing_data = cfm_get_existing_data(); // Replace this with your own code to fetch the existing data
    // Retrieve the current value of the custom field
    $serialized_data = unserialize(get_post_meta($post->ID, 'custom_fields_manager', true));
    $allow_unsanitized = false;
    if (isset($serialized_data['allow_unsanitized'])) {
        $allow_unsanitized = $serialized_data['allow_unsanitized'];
    }
    foreach ($existing_data["items"] as $key => $item) {
        if (isset($serialized_data[$item['name']])) {
            $existing_data['items'][$key]['value'] = urldecode($serialized_data[$item['name']]);
        } else {
            $existing_data['items'][$key]['value'] = "";
        }
    }

    // Output the HTML for the custom field
    wp_nonce_field('custom_fields_manager', 'custom_fields_manager_nonce');
    $terms = get_terms([
        'taxonomy'   => 'category', // Specify 'category' to retrieve only categories
        'hide_empty' => false,      // Set to false to include categories with no posts
    ]);



?>
    <?php foreach ($existing_data["items"] as $item) : ?>
        <div class="cfm-form-field">
            <label for="<?php echo cfm_get_field_name($item["name"]); ?>"><?php echo $item["label"]; ?>:</label>
            <?php if ($item["type"] === "text") : ?>
                <input type="text" id="<?php echo cfm_get_field_name($item["name"]); ?>" name="<?php echo cfm_get_field_name($item["name"]); ?>" value="<?php echo esc_attr($item['value']); ?>">
            <?php elseif ($item["type"] === "textarea") : ?>
                <textarea id="<?php echo cfm_get_field_name($item["name"]); ?>" name="<?php echo cfm_get_field_name($item["name"]); ?>" rows="20"><?php echo esc_attr($item['value']); ?></textarea>
            <?php elseif ($item["type"] === "post-category") : ?>
                <select id="<?php echo cfm_get_field_name($item["name"]); ?>" name="<?php echo cfm_get_field_name($item["name"]); ?>" value="<?php echo esc_attr($item['value']); ?>">
                    <option value="">Select Post Category</option>
                    <?php
                    if (!empty($terms)) {
                        foreach ($terms as $term) {
                            $term_id   = $term->term_id;
                            $term_name = $term->name;
                            $term_slug = $term->slug;

                            // Do something with the category information
                            // For example, echo the category name
                            echo '<option value="' . $term_id . '" ' . selected($item['value'], $term_id) . '>' . $term_name . '</option>';
                        }
                    }
                    ?>
                </select>
            <?php endif; ?>
        </div>
    <?php endforeach; ?>

    <div class="cfm-form-field cfm-form-field-row">
        <label for="allow_unsanitized">Allow Unsanitized Data:</label>
        <input type="checkbox" id="allow_unsanitized" name="allow_unsanitized" value="1" <?php echo $allow_unsanitized ? 'checked' : '' ?>>
    </div>
    <div class="cfm-note-section">
        <div class="cfm_accordion">
            <div class="cfm_accordion-item">
                <div class="cfm_accordion-heading">
                    <div class="cfm_accordion-title"><strong>Note:</strong> Allow unsanitized data for schema/meta tags and custom style tags, but be cautious of <strong>security vulnerabilities</strong> and <strong>compatibility issues</strong>.
                    </div>
                    <div class="cfm_accordion-icon">+</div>
                </div>
                <div class="cfm_accordion-content">
                    <p>The "Allow Unsanitized Data" option provides the ability to store data without any sanitization or filtering. Enabling this option means that user-entered data will be saved as-is, without any modifications.</p>
                    <p>While it is generally recommended to sanitize and filter user input, there are specific use cases where allowing unsanitized data can be appropriate:</p>
                    <ul>
                        <li><span class="cfm_note-highlight">Schema and Meta Tags:</span> In certain situations, such as storing structured data for schema markup or meta tags, it may be necessary to allow unsanitized data to ensure the tags are preserved and can be used as intended.</li>
                        <li><span class="cfm_note-highlight">Custom Style Tags:</span> Allowing unsanitized data can be useful when users need to add custom style tags for page-level customization, such as custom CSS styles. This gives users more control over the appearance of their content.</li>
                    </ul>
                    <p>However, it's important to understand the potential risks associated with allowing unsanitized data:</p>
                    <ul>
                        <li class="cfm_risk-item"><span class="cfm_note-highlight">Security Vulnerabilities:</span> Allowing unsanitized data, especially HTML tags, can introduce security vulnerabilities like cross-site scripting (XSS) attacks. Malicious code embedded within the data may execute when the content is rendered.</li>
                        <li class="cfm_risk-item"><span class="cfm_note-highlight">Compatibility Issues:</span> Some platforms or environments where the data is displayed may have restrictions on certain HTML tags or attributes for security reasons. Allowing unsanitized data containing restricted tags or attributes can cause compatibility issues or lead to unexpected behavior.</li>
                        <li class="cfm_risk-item"><span class="cfm_note-highlight">Data Consistency:</span> Lack of sanitization means the data may contain inconsistent or malformed HTML, which can affect the overall integrity and appearance of your website or application.</li>
                    </ul>
                </div>
            </div>
        </div>

    </div>
<?php
}

function custom_save_meta_box($post_id)
{
    if (!current_user_can('edit_post', $post_id)) {
        return;
    }

    // Verify the nonce for security
    if (!isset($_POST['custom_fields_manager_nonce']) || !wp_verify_nonce($_POST['custom_fields_manager_nonce'], 'custom_fields_manager')) {
        return;
    }

    // Save the custom field value

    $existing_data = cfm_get_existing_data(); // Replace this with your own code to fetch the existing data
    $isSanitize = true;
    if (isset($_POST['allow_unsanitized'])) {
        $isSanitize = $_POST['allow_unsanitized'] !== '1';
    }
    // Serialize the nested data structure
    $customSaveData = [];
    foreach ($existing_data["items"] as $key => $item) {
        if (isset($_POST[cfm_get_field_name($item['name'])])) {
            $saveValue = stripslashes($_POST[cfm_get_field_name($item['name'])]);
            if ($isSanitize) {
                // Sanitize text input
                if ($item['type'] === 'text') {
                    $saveValue = sanitize_text_field($saveValue);
                }

                // Sanitize textarea input
                if ($item['type'] === 'textarea') {
                    $allowed_html = wp_kses_allowed_html(); // Get the list of allowed HTML tags and attributes

                    $saveValue = wp_kses($saveValue, $allowed_html); // Sanitize the user input

                }
            }
            $customSaveData[$item['name']] = urlencode($saveValue);
        }
    }
    $customSaveData['allow_unsanitized'] = !$isSanitize;
    $serialized_data = serialize($customSaveData);
    // Save the serialized data using update_post_meta()
    update_post_meta($post_id, 'custom_fields_manager', $serialized_data);
}
add_action('save_post', 'custom_save_meta_box');
