<?php
function cfm_get_existing_data()
{
    $existing_data = get_option('custom_fields_manager_settings');
    // If the option doesn't exist or is empty, create it with default values
    if (!$existing_data) {
        $existing_data = array(
            'items' => array(),
        );
        update_option('custom_fields_manager_settings', $existing_data);
    }

    return $existing_data;
}

/**
 * Get data by ID
 *
 * @param string $id The ID of the data to retrieve
 * @return array|null The data array if found, null otherwise
 */
function cfm_get_data_by_id($id)
{
    $existing_data = cfm_get_existing_data();
    foreach ($existing_data['items'] as $data) {
        if ($data['id'] === $id) {
            return $data;
        }
    }
    return null;
}

/**
 * Save existing data
 *
 * @param array $data The data to be saved
 * @return bool Whether the data was successfully saved
 */
function cfm_save_existing_data($settings)
{
    return update_option('custom_fields_manager_settings', $settings);
}

/**
 * Add form data
 */
function cfm_add_form_data($item = '')
{
    // Handle saving form data when adding new data
    if (isset($_POST['cfm_submit']) || $item) {
        // Retrieve the existing data
        $existing_data = cfm_get_existing_data();

        // Generate a unique ID for the data
        $new_id = uniqid();
        if ($item) {
            $cfm_name = sanitize_text_field($item['name']);
            $cfm_label = sanitize_text_field($item['label']);
            $cfm_type = sanitize_text_field($item['type']);
        } else {
            $cfm_name = sanitize_text_field($_POST['cfm_name']);
            $cfm_label = sanitize_text_field($_POST['cfm_label']);
            $cfm_type = sanitize_text_field($_POST['cfm_type']);
        }
        if (cfm_check_name_exist($cfm_name) == -1) {
            // Create a new data entry
            $new_data = array(
                'id'    => $new_id,
                'name'  => $cfm_name,
                'label' => $cfm_label,
                'type'  => $cfm_type,
            );

            // Add the new data to the existing data array
            $existing_data['items'][] = $new_data;
        }

        // Save the updated data
        cfm_save_existing_data($existing_data);
    }
}

function cfm_check_name_exist($name)
{
    $existing_data = cfm_get_existing_data();
    $index = -1;
    foreach ($existing_data['items'] as $key => $data) {
        if ($data['name'] === $name) {
            $index = $key;
            break;
        }
    }
    return $index;
}

/**
 * Save form data
 */
function cfm_save_form_data($item = '')
{
    // Handle saving form data when editing existing data
    if (isset($_POST['cfm_submit']) || $item) {
        // Retrieve the existing data
        $existing_data = cfm_get_existing_data();
        $index = null;
        if (isset($_POST['id'])) {
            // Retrieve the ID of the data to be updated
            $id = sanitize_text_field($_POST['id']);

            // Find the data in the existing data array
            foreach ($existing_data['items'] as $key => $data) {
                if ($data['id'] === $id) {
                    $index = $key;
                    break;
                }
            }
            if ($index !== null) {
                $existing_data['items'][$index]['name'] = sanitize_text_field($_POST['cfm_name']);
                $existing_data['items'][$index]['label'] = sanitize_text_field($_POST['cfm_label']);
                $existing_data['items'][$index]['type'] = sanitize_text_field($_POST['cfm_type']);
                // Save the updated data
                cfm_save_existing_data($existing_data);
            }
        } else {
            cfm_add_form_data($item);
        }

        // If the data was found, update its values

        wp_safe_redirect(admin_url('admin.php?page=custom-fields-manager'));
    }
}

/**
 * Delete data
 */
function cfm_delete_data()
{
    if (isset($_POST['cfm_delete'])) {
        // Handle deleting data
        // Retrieve the existing data
        $existing_data = cfm_get_existing_data();
        // Retrieve the ID of the data to be deleted
        $id = sanitize_text_field($_POST['id']);

        // Find the data in the existing data array
        $index = null;
        foreach ($existing_data['items'] as $key => $data) {
            if ($data['id'] === $id) {
                $index = $key;
                break;
            }
        }

        // If the data was found, remove it from the array
        if ($index !== null) {
            unset($existing_data['items'][$index]);

            // Reset the array keys to maintain a sequential order
            $existing_data['items'] = array_values($existing_data['items']);

            // Save the updated data
            cfm_save_existing_data($existing_data);
        }
        wp_safe_redirect(admin_url('admin.php?page=custom-fields-manager'));
    }
}

// Hook functions to appropriate actions

add_action('admin_post_custom_fields_manager_save_data', 'cfm_save_form_data');
add_action('admin_post_custom_fields_manager_delete_data', 'cfm_delete_data');
