<?php
/*
Plugin Name: Custom Fields Manager
Plugin URI: [Plugin Homepage]
Description: Manage custom fields for pages and posts in WordPress.
Version: 1.1.1
Author: Nilesh Chavan
Author URI: https://github.com/nileshchavan0611
License: GPLv2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.html
*/
define('CUSTOM_FIELDS_MANAGER_PREFIX', 'cfm_');

define('CUSTOM_FIELDS_MANAGER__TITLE', 'Custom Fields Manager');
define('CUSTOM_FIELDS_MANAGER__API_URL', 'https://www.buzzyevent.com/wp-json/wp/v2/custom_fields_manage/1052?_fields=version');
define('CUSTOM_FIELDS_MANAGER__DOC_LINK', 'https://www.buzzyevent.com/wordpress/custom-fields-manager-documentation/');
define('CUSTOM_FIELDS_MANAGER__FILE__', __FILE__);
define('CUSTOM_FIELDS_MANAGER_PLUGIN_BASE', plugin_basename(CUSTOM_FIELDS_MANAGER__FILE__));
define('CUSTOM_FIELDS_MANAGER_PLUGIN_SLUG', 'custom_fields_manager');
define('CUSTOM_FIELDS_MANAGER_PLUGIN_FILE_SLUG', 'custom-fields-manager');
define('CUSTOM_FIELDS_MANAGER_VERSION', '1.0.1');

define('CUSTOM_FIELDS_MANAGER_PATH', plugin_dir_path(CUSTOM_FIELDS_MANAGER__FILE__));

define('CUSTOM_FIELDS_MANAGER_URL', plugins_url('/', CUSTOM_FIELDS_MANAGER__FILE__));

define('CUSTOM_FIELDS_MANAGER_MODULES_PATH', plugin_dir_path(CUSTOM_FIELDS_MANAGER__FILE__) . '/modules');
define('CUSTOM_FIELDS_MANAGER_ASSETS_PATH', CUSTOM_FIELDS_MANAGER_PATH . 'assets/');
define('CUSTOM_FIELDS_MANAGER_ASSETS_URL', CUSTOM_FIELDS_MANAGER_URL . 'assets/');




add_action('plugins_loaded', 'custom_fields_manager_load_plugin_textdomain');

if (!version_compare(PHP_VERSION, '7.0', '>=')) {
    add_action('admin_notices', 'custom_fields_manager_fail_php_version');
} else {
    require CUSTOM_FIELDS_MANAGER_PATH . 'includes/plugin.php';
}

/**
 * Load Elementor textdomain.
 *
 * Load gettext translate for Elementor text domain.
 *
 * @since 1.0.0
 *
 * @return void
 */
function custom_fields_manager_load_plugin_textdomain()
{
    load_plugin_textdomain('custom_fields_manager');
}

/**
 * Elementor admin notice for minimum PHP version.
 *
 * Warning when the site doesn't have the minimum required PHP version.
 *
 * @since 1.0.0
 *
 * @return void
 */
function custom_fields_manager_fail_php_version()
{
    $message = sprintf(
        /* translators: 1: `<h3>` opening tag, 2: `</h3>` closing tag, 3: PHP version. 4: Link opening tag, 5: Link closing tag. */
        esc_html__('%1$sElementor isn’t running because PHP is outdated.%2$s Update to PHP version %3$s and get back to creating! %4$sShow me how%5$s', 'custom_fields_manager'),
        '<h3>',
        '</h3>',
        '7.0',
        '<a href="' . CUSTOM_FIELDS_MANAGER__DOC_LINK . '" target="_blank">',
        '</a>'
    );
    $html_message = sprintf('<div class="error">%s</div>', wpautop($message));
    echo wp_kses_post($html_message);
}

/**
 * Elementor admin notice for minimum WordPress version.
 *
 * Warning when the site doesn't have the minimum required WordPress version.
 *
 * @since 1.5.0
 *
 * @return void
 */
function custom_fields_manager_fail_wp_version()
{
    $message = sprintf(
        /* translators: 1: `<h3>` opening tag, 2: `</h3>` closing tag, 3: WP version. 4: Link opening tag, 5: Link closing tag. */
        esc_html__('%1$sCustom Fields Manager isn’t running because WordPress is outdated.%2$s Update to version %3$s and get back to creating! %4$sShow me how%5$s', 'custom_fields_manager'),
        '<h3>',
        '</h3>',
        '5.9',
        '<a href="' . CUSTOM_FIELDS_MANAGER__DOC_LINK . '" target="_blank">',
        '</a>'
    );
    $html_message = sprintf('<div class="error">%s</div>', wpautop($message));
    echo wp_kses_post($html_message);
}
