<?php
class CFM_Categories_Mapping_Form
{
    public function __construct()
    {
        add_action('admin_menu', array($this, 'add_plugin_page'));
        add_action('admin_init', array($this, 'page_init'));
        add_action('admin_post_save_categories_mapping', array($this, 'save_categories_mapping'));
        add_action('admin_post_delete_category_mapping', array($this, 'delete_category_mapping'));
    }

    public function add_plugin_page()
    {
        add_submenu_page(
            'custom-fields-manager',
            'Categories Mapping',
            'Categories Mapping',
            'manage_options',
            'cfm-categories-mapping',
            array($this, 'create_admin_page')
        );
    }

    public function create_admin_page()
    {
        $this->display_categories_mapping_form();
    }

    public function display_categories_mapping_form()
    {
        // Retrieve the current site categories
        $current_categories = get_terms([
            'taxonomy'   => 'category', // Specify 'category' to retrieve only categories
            'hide_empty' => false,      // Set to false to include categories with no posts
        ]);

        // Retrieve the existing category mappings from the database
        $existing_mappings = $this->get_existing_category_mappings();

        // Display the form and the existing mappings
?>
        <div class="wrap">
            <h1>Categories Mapping Form</h1>
            <form method="post" action="<?php echo admin_url('admin-post.php'); ?>">
                <input type="hidden" name="action" value="save_categories_mapping">
                <div class="cfm-d-flex">
                    <div class="cfm-mr cfm-mb">
                        <h2>Current Site Categories</h2>
                        <select name="current_categories" id="current_categories">
                            <?php if (!empty($current_categories)) : ?>
                                <?php foreach ($current_categories as $category) : ?>
                                    <option value="<?php echo $category->slug; ?>"><?php echo $category->name; ?></option>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <option value="">No categories found</option>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="cfm-mr cfm-mb">
                        <h2>API Category</h2>
                        <input type="text" name="api_category" placeholder="Enter API Category">
                    </div>
                </div>
                <button type="submit" class="button cfm-add-button">Save Mapping</button>
            </form>
            <hr>
            <h2>Existing Category Mappings</h2>
            <?php if (!empty($existing_mappings)) : ?>
                <table class="wp-list-table widefat fixed striped">
                    <thead>
                        <tr>
                            <th scope="col">Current Category</th>
                            <th scope="col">API Category</th>
                            <th scope="col">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($existing_mappings as $mapping) : ?>
                            <tr>
                                <td><?php echo $mapping['current_category']; ?></td>
                                <td><?php echo $mapping['api_category']; ?></td>
                                <td>
                                    <form method="post" action="<?php echo admin_url('admin-post.php'); ?>" style="display: inline-block;">
                                        <input type="hidden" name="action" value="delete_category_mapping">
                                        <input type="hidden" name="current_category" value="<?php echo $mapping['current_category']; ?>">
                                        <input type="hidden" name="api_category" value="<?php echo $mapping['api_category']; ?>">
                                        <button type="submit" class="button cfm-delete-button" onclick="return confirm('Are you sure you want to delete this mapping?')">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else : ?>
                <p>No existing category mappings found.</p>
            <?php endif; ?>
        </div>
<?php
    }

    public function page_init()
    {
        // Initialize plugin settings
    }

    public function save_categories_mapping()
    {
        // Handle saving category mapping
        if (isset($_POST['current_categories']) && isset($_POST['api_category'])) {
            $current_category = sanitize_text_field($_POST['current_categories']);
            $api_category = sanitize_text_field($_POST['api_category']);

            // Validate and sanitize the data as needed

            // Save the category mapping to the database
            $existing_mappings = $this->get_existing_category_mappings();
            $existing_mappings[] = array(
                'current_category' => $current_category,
                'api_category' => $api_category
            );
            // Save $existing_mappings back to the database

            update_option('cfm_category_mappings', serialize($existing_mappings));
            // Redirect back to the mapping form
            wp_redirect(admin_url('admin.php?page=cfm-categories-mapping'));
            exit;
        }
    }

    public function delete_category_mapping()
    {
        // Handle deleting category mapping
        if (isset($_POST['current_category']) && isset($_POST['api_category'])) {
            $current_category = sanitize_text_field($_POST['current_category']);
            $api_category = sanitize_text_field($_POST['api_category']);

            // Retrieve the existing mappings from the database
            $existing_mappings = $this->get_existing_category_mappings();

            // Find and remove the mapping based on the current and API categories
            $updated_mappings = array();
            foreach ($existing_mappings as $mapping) {
                if ($mapping['current_category'] !== $current_category || $mapping['api_category'] !== $api_category) {
                    $updated_mappings[] = $mapping;
                }
            }
            // Save $updated_mappings back to the database
            update_option('cfm_category_mappings', serialize($updated_mappings));
            // Redirect back to the mapping form
            wp_redirect(admin_url('admin.php?page=cfm-categories-mapping'));
            exit;
        }
    }

    public function get_existing_category_mappings()
    {
        $existing_mappings = unserialize(get_option('cfm_category_mappings', serialize(array())));

        return $existing_mappings;
    }
}

// Instantiate the CFM_Categories_Mapping_Form class
new CFM_Categories_Mapping_Form();
