<?php
class CFM_Blog_Import
{
    public function __construct()
    {
        add_action('admin_menu', array($this, 'add_import_submenu'));
    }

    public function add_import_submenu()
    {
        add_submenu_page(
            'custom-fields-manager',     // Parent menu slug
            'Blog Manager Import',       // Page title
            'Blog Manager Import',       // Menu title
            'manage_options',            // Capability required to access the menu
            'blog-manager-import',       // Menu slug
            array($this, 'import_posts_page') // Callback function to render the sub-menu page
        );
    }

    public function import_posts_page()
    {
?>
        <div class="wrap">
            <h1>Blog Manager Import</h1>
            <form method="post" action="">
                <div class="cfm-form-field">
                    <label for="api_url"><?php echo esc_html__('API URL', 'custom-fields-manager'); ?>:</label>
                    <input type="text" id="api_url" name="api_url" placeholder="https://www.buzzyevent.com/wp-json/wp/v2/posts?order=asc&orderby=date&per_page=10">
                </div>
                <div class="cfm-form-field">
                    <label for="api_category_url"><?php echo esc_html__('API Category URL', 'custom-fields-manager'); ?>:</label>
                    <input type="text" id="api_category_url" name="api_category_url" placeholder="https://www.buzzyevent.com/wp-json/wp/v2/categories/">
                </div>
                <button type="submit" class="button">Import Posts</button>
            </form>
        </div>
<?php

        if (isset($_POST['api_url'])) {

            // Process the import based on the API URL
            $api_url = $_POST['api_url'];

            // Call the API and retrieve the JSON response
            $response = wp_remote_get($api_url);
            $imported_posts = json_decode(wp_remote_retrieve_body($response), true);

            $api_category_list = [];

            // Check if the API response is valid and contains posts
            if (is_array($imported_posts) && !empty($imported_posts)) {
                $count = count($imported_posts);

                // Loop through the imported posts and create them in WordPress
                foreach ($imported_posts as $post_data) {
                    // Extract the required post data
                    $post_id = $post_data['id'];
                    $title = $post_data['title']['rendered'];
                    $content = $post_data['content']['rendered'];
                    $date = $post_data['date'];
                    $slug = $post_data['slug'];
                    $link = $post_data['link'];
                    $excerpt = $post_data['excerpt']['rendered'];
                    $created_date = $post_data['date'];
                    $post_date = date('Y-m-d H:i:s', strtotime($created_date));
                    try {
                        $categoryID = $post_data['categories'][0];
                    } catch (\Throwable $th) {
                        //throw $th;
                        $categoryID = "";
                    }
                    $featured_image_url = $post_data['featured_image_url'];


                    // Check if a post with the same slug already exists
                    $existing_post = get_page_by_path($slug, OBJECT, 'post');

                    if ($existing_post) {
                        // Post with the same slug already exists, skip creating a new post
                        echo '<p>' . sprintf(__('Skipped importing post "%s" - Slug already exists.', 'custom-fields-manager'), $title) . '</p>';
                        continue;
                    }

                    // Prepare the post data
                    $post_data = array(
                        'post_title'   => $title,
                        'post_content' => $content,
                        'post_excerpt' => $excerpt, // Set the post excerpt
                        'post_name'    => $slug,
                        'post_date'    => $post_date, // Set the post_date as the created date
                        'post_status'  => 'publish',
                        'post_type'    => 'post',
                    );

                    // Insert the post into WordPress
                    $post_id = wp_insert_post($post_data);

                    if ($post_id) {
                        if (!empty($featured_image_url)) {
                            $image_data = file_get_contents($featured_image_url);
                            $filename = basename($featured_image_url);
                            $upload_dir = wp_upload_dir();
                            $image_path = $upload_dir['path'] . '/' . $filename;
                            file_put_contents($image_path, $image_data);
                            $wp_filetype = wp_check_filetype($filename, null);
                            $attachment = array(
                                'post_mime_type' => $wp_filetype['type'],
                                'post_title' => sanitize_file_name($filename),
                                'post_content' => '',
                                'post_status' => 'inherit'
                            );
                            $attach_id = wp_insert_attachment($attachment, $image_path, $post_id);
                            $attach_data = wp_generate_attachment_metadata($attach_id, $image_path);
                            wp_update_attachment_metadata($attach_id, $attach_data);
                            set_post_thumbnail($post_id, $attach_id);
                        }
                        // Map category based on URL
                        $category = '';
                        $permalink = $link;
                        $categoriesList = [];
                        $categoryMapList = new CFM_Categories_Mapping_Form();
                        $existing_mappings = $categoryMapList->get_existing_category_mappings();
                        foreach ($existing_mappings as $mapping) {
                            $categoriesList[$mapping['api_category']] = $mapping['current_category'] ;
                        }

                        $category = ''; // Initialize the category variable
                        if ($categoryID) {
                            $api_category_url = $_POST['api_category_url'];

                            // Call the API and retrieve the JSON response
                            $api_category_url = rtrim($api_category_url, '/') . '/'; // Ensure trailing slash
                            $api_category_url .= $categoryID; // Append category ID
                            $category_response = wp_remote_get($api_category_url);

                            $imported_posts_category = json_decode(wp_remote_retrieve_body($category_response), true);
                            if($imported_posts_category){
                                if (isset($categoriesList[$imported_posts_category['slug']])) {
                                    $category = $categoriesList[$imported_posts_category['slug']];
                                } else {
                                    $category = $imported_posts_category['slug'];
                                }
                            }
                        }

                        // Set the category for the imported post
                        if (!empty($category)) {
                            $categoryObj = get_category_by_slug($category);
                            if ($categoryObj && $categoryObj->term_id !== 0) {
                                wp_set_post_categories($post_id, array($categoryObj->term_id));
                            }
                        }
                        // Post inserted successfully
                        echo '<p>' . sprintf(__('Post "%s" imported successfully. %s', 'custom-fields-manager'), $title, $date) . '</p>';
                    } else {
                        // Failed to insert the post
                        echo '<p>' . sprintf(__('Failed to import post "%s".', 'custom-fields-manager'), $title) . '</p>';
                    }
                }

                // Show the total number of imported posts
                echo '<p>' . sprintf(__('Successfully imported %d posts.', 'custom-fields-manager'), $count) . '</p>';
            } else {
                // No posts found in the API response
                echo '<p>' . __('No posts found in the API response.', 'custom-fields-manager') . '</p>';
            }
        }
    }
}

// Instantiate the class
$cfm_blog_import = new CFM_Blog_Import();
