<?php

class CFM_Blog_Export
{
    public function __construct()
    {
        add_action('admin_menu', array($this, 'add_export_submenu'));
        add_action('admin_post_cfm_blog_export_posts', array($this, 'export_posts_action'));
    }

    public function add_export_submenu()
    {
        add_submenu_page(
            'custom-fields-manager',     // Parent menu slug
            'Blog Manager Export',       // Page title
            'Blog Manager Export',       // Menu title
            'manage_options',            // Capability required to access the menu
            'cfm-blog-manager-export',       // Menu slug
            array($this, 'export_posts_page') // Callback function to render the sub-menu page
        );
    }
    public function export_posts_page()
    {
        $terms = get_terms([
            'taxonomy'   => 'category', // Specify 'category' to retrieve only categories
            'hide_empty' => false,      // Set to false to include categories with no posts
        ]);

?>
        <div class="wrap">
            <h1>Blog Manager Export</h1>
            <form method="post" action="<?php echo admin_url('admin-post.php'); ?>">
                <input type="hidden" name="action" value="cfm_blog_export_posts">

                <h2 class="cfm-form-field">Date Range</h2>
                <div class="cfm-d-flex">
                    <div class="cfm-form-field cfm-mr">
                        <label>
                            <input type="radio" name="date_option" value="range" checked>
                            <?php echo esc_html__('Date Range', 'custom-fields-manager'); ?>
                        </label>
                    </div>
                    <div class="cfm-form-field">
                        <label>
                            <input type="radio" name="date_option" value="all">
                            <?php echo esc_html__('Export All Dates', 'custom-fields-manager'); ?>
                        </label>
                    </div>
                </div>

                <div id="date_range_fields" class="cfm-d-flex">
                    <div class="cfm-form-field">
                        <label for="start_date"><?php echo esc_html__('Start Date', 'custom-fields-manager'); ?>:</label>
                        <input type="date" id="start_date" name="start_date">
                    </div>
                    <div class="cfm-form-field">
                        <label for="end_date"><?php echo esc_html__('End Date', 'custom-fields-manager'); ?>:</label>
                        <input type="date" id="end_date" name="end_date">
                    </div>
                </div>

                <h2>Categories</h2>
                <div class="cfm-categories">
                    <?php
                    if (!empty($terms)) {
                        foreach ($terms as $term) {
                            $term_id   = $term->term_id;
                            $term_name = $term->name;
                            $term_slug = $term->slug;

                            echo '<div class="cfm-category-checkbox">';
                            echo '<input type="checkbox" name="categories[]" id="category_' . $term_id . '" value="' . $term_id . '">';
                            echo '<label for="category_' . $term_id . '">' . $term_name . '</label>';
                            echo '</div>';
                        }
                    } else {
                        echo esc_html__('No categories found.', 'custom-fields-manager');
                    }
                    ?>
                </div>
                <h2>Columns</h2>
                <div class="cfm-columns">
                    <?php
                    $column_list = array(); // Array to store the selected columns

                    $columns = array(
                        'publish_date' => 'Publish Date',
                        'created_date' => 'Created Date',
                        'modified_date' => 'Modified Date',
                        'title' => 'Title',
                        'meta_title' => 'Meta Title',
                        'meta_description' => 'Meta Description',
                        'slug' => 'Slug',
                        'url' => 'URL',
                        'category' => 'Category'
                    );

                    foreach ($columns as $key => $label) {
                        $checkbox_id = 'column_' . $key;

                        echo '<div class="cfm-column-checkbox">';
                        echo '<input type="checkbox" name="columns[]" id="' . $checkbox_id . '" value="' . $key . '">';
                        echo '<label for="' . $checkbox_id . '">' . $label . '</label>';
                        echo '</div>';
                    }
                    ?>
                </div>
                <div class="cfm-form-field">
                    <label for="per_page"><?php echo esc_html__('Per Page', 'custom-fields-manager'); ?>: <small><strong>-1</strong> value is use for all data</small></label>
                    <input type="number" id="per_page" name="per_page" value="100">
                </div>
                <div class="cfm-form-field">
                    <label for="page_no"><?php echo esc_html__('Page Number', 'custom-fields-manager'); ?>:</label>
                    <input type="number" min="1" id="page_no" name="page_no" value="1">
                </div>
                <button type="submit" class="button">Export Posts</button>
            </form>
        </div>
<?php
    }


    public function export_posts_action()
    {
        // Get the form data
        // Perform the export process based on the form data
        // Example: Retrieve posts, filter by date range and category, export selected columns

        // Generate the CSV file
        $csv_content = $this->generate_csv_file();

        // Download the CSV file
        $this->download_csv_file($csv_content);
    }

    private function generate_csv_file()
    {
        // Get the form data
        $start_date = $_POST['start_date'];
        $end_date = $_POST['end_date'];
        $page_no = $_POST['page_no'];
        $per_page = $_POST['per_page'];
        $categories = null;
        $columns = ['id', 'title', 'url'];
        if (isset($_POST['page_no'])) {
            $page_no = $_POST['page_no'];
        } else {
            $page_no = 1;
        }
        if (isset($_POST['per_page'])) {
            $per_page = $_POST['per_page'];
        }
        if (isset($_POST['categories'])) {
            $categories = $_POST['categories'];
        }
        if (isset($_POST['columns'])) {
            $columns = $_POST['columns'];
        }

        // Perform the export process based on the form data
        // Example: Retrieve posts, filter by date range and category, export selected columns

        // Prepare the CSV data
        $csv_data = array();

        // Add the selected columns to the column headers
        $column_labels = array(
            'id' => 'Id',
            'publish_date' => 'Publish Date',
            'created_date' => 'Created Date',
            'modified_date' => 'Modified Date',
            'title' => 'Title',
            'meta_title' => 'Meta Title',
            'meta_description' => 'Meta Description',
            'slug' => 'Slug',
            'url' => 'URL',
            'category' => 'Category'
        );

        foreach ($columns as $column) {
            if (isset($column_labels[$column])) {
                $column_headers[] = $column_labels[$column];
            }
        }

        $csv_data[] = $column_headers;

        // Query the posts based on the export criteria (start date, end date, categories)

        // Example query using WP_Query
        $args = array(
            'post_type' => 'post',
            'post_status' => 'publish',
            'posts_per_page' => $per_page,   // Replace 10 with the desired number of posts per page
            'offset'         => $per_page * ($page_no - 1),
        );

        // Add the taxonomy filter only if categories are selected
        if (!empty($categories)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'category',
                    'field' => 'term_id',
                    'terms' => $categories,
                ),
            );
        }
        if (!empty($start_date) && !empty($end_date)) {
            $args['date_query'] = array(
                'after' => $start_date,
                'before' => $end_date,
            );
        }

        $query = new WP_Query($args);


        if ($query->have_posts()) {
            while ($query->have_posts()) {
                $query->the_post();

                // Retrieve the required data for each post
                $post_id = get_the_ID();
                $publish_date = get_the_date('Y-m-d');
                $created_date = get_the_date('Y-m-d');
                $modified_date = get_the_modified_date('Y-m-d');
                $title = get_the_title();
                $meta_title = get_post_meta($post_id, 'meta_title', true);
                $meta_description = get_post_meta($post_id, 'meta_description', true);
                $slug = get_post_field('post_name', $post_id);
                $url = get_permalink();
                $category = get_the_category()[0]->name;

                // Prepare the row data with selected columns
                $row_data = array(
                    'id' => $post_id,
                    'publish_date' => $publish_date,
                    'created_date' => $created_date,
                    'modified_date' => $modified_date,
                    'title' => '"' . $title . '"',
                    'meta_title' => $meta_title,
                    'meta_description' => $meta_description,
                    'slug' => $slug,
                    'url' => $url,
                    'category' => $category
                );
                // Filter the row data based on the selected columns
                $filtered_row_data = array();
                foreach ($columns as $column) {
                    if (isset($row_data[$column])) {
                        $filtered_row_data[] = $row_data[$column];
                    } else {
                        $filtered_row_data[] = ''; // Empty value if the column data is not available
                    }
                }

                // Add the filtered row data to the CSV data
                $csv_data[] = $filtered_row_data;
            }
        }

        // Restore the original post data
        wp_reset_postdata();

        // Generate the CSV content
        $csv_content = '';
        foreach ($csv_data as $csv_row) {
            $csv_content .= implode(',', $csv_row) . "\n";
        }

        return $csv_content;
    }


    private function download_csv_file($csv_content)
    {
        // Set the appropriate headers for file download
        header("Content-Type: text/csv");
        header("Content-Disposition: attachment; filename=exported_posts.csv");
        header("Pragma: no-cache");
        header("Expires: 0");

        // Output the CSV content to the browser
        echo $csv_content;

        // Stop further script execution
        exit;
    }
}

// Instantiate the class
$cfm_blog_export = new CFM_Blog_Export();
