# Custom Fields Manager Plugin

Custom Fields Manager is a WordPress plugin that allows you to manage custom fields for posts and pages.

## Description

The `custom_fields_manager` plugin provides a user-friendly interface to add and manage custom fields for your posts and pages in WordPress. It allows you to define custom fields, such as text fields and text areas, and associate them with your posts and pages.

The plugin creates a meta box on the post and page edit screens where you can enter values for the custom fields. The entered values are then stored as post meta data and can be retrieved and displayed in your WordPress templates.

## Installation

1. Upload the custom-fields-manager.zip file to your WordPress site.
2. Navigate to the ‘Plugins’ section in your WordPress dashboard.
3. Click on the ‘Add New’ button.
4. Click on the ‘Upload Plugin’ button.
5. Choose the custom-fields-manager.zip file and click ‘Install Now’.
6. Activate the plugin.
## Usage

1. Go to the post or page edit screen in WordPress.
2. Scroll down to the "Custom Fields Manager Data" meta box.
3. Enter values for the custom fields.
4. Update or publish the post or page.
5. To retrieve and display the custom field values in your template, use the `cfm_get_field_value()` function passing the custom field name as a parameter.

Example usage:

```php
$field_value = cfm_get_field_value('custom_field_name', $post_id);
echo $field_value;
```

Replace `'custom_field_name'` with the actual name of your custom field.

## Features

- Manage custom fields and meta boxes for posts and pages.
- Define and organize your custom data fields.
- Easily edit and update custom field values for individual posts or pages.
- Export blog posts using the Blog Manager Export feature.
- Import blog posts using the Blog Manager Import feature.
- Map categories between WordPress and an external API using the Blog Categories Mapping Form.
- Comprehensive documentation and usage instructions available on our website [https://www.buzzyevent.com/wordpress/custom-fields-manager-documentation/].

## Exporting Blog Posts

The Custom Fields Manager plugin provides a convenient way to export your blog posts. Follow these steps to export your posts:

1. Go to the WordPress dashboard and navigate to the "Tools" menu.
2. Click on "Custom Fields Manager Export".
3. Select the desired export options, such as post types, date range, and custom field filters.
4. Click on the "Export" button to initiate the export process.
5. The plugin will generate a downloadable file containing the exported blog posts in a suitable format.

## Importing Blog Posts

The Custom Fields Manager plugin also offers an import feature to easily import blog posts into your WordPress site. Follow these steps to import your posts:

1. Go to the WordPress dashboard and navigate to the "Tools" menu.
2. Click on "Custom Fields Manager Import".
3. Choose the file you want to import, which should be in a compatible format.
4. Configure the import settings, such as post status, category mapping, and custom field handling.
5. Click on the "Import" button to start the import process.
6. The plugin will process the imported file and create the corresponding blog posts in your WordPress site.

## Blog Categories Mapping

The Custom Fields Manager plugin allows you to map categories between WordPress and an external API using the Blog Categories Mapping Form. This feature helps you synchronize category data and maintain consistency between your WordPress site and the external API.

To map categories, follow these steps:

1. Go to the WordPress dashboard and navigate to the "Tools" menu.
2. Click on "Blog Categories Mapping Form".
3. Enter the necessary details, such as the API category name and the corresponding WordPress category slug.
4. Click on the "Add Mapping" button to create the category mapping.
5. Repeat the above steps for any additional category mappings you want to create.

## Frequently Asked Questions

**Q: How can I display the custom field values in my theme templates?**
A: Use the `cfm_get_field_value()` function passing the custom field name as a parameter. The function will return the value of the custom field, which you can then display in your templates.

**Q: How do I add custom fields and meta boxes?**
A: Once the plugin is activated, you can define your custom fields and meta boxes in the settings page.

**Q: Can I use this plugin with any theme?**
A: Yes, the plugin is designed to work with any theme that follows WordPress coding standards.

**Q: Is there any documentation available for this plugin?**
A: Yes, you can find detailed documentation and usage instructions on our website [https://www.buzzyevent.com/wordpress/custom-fields-manager-documentation/].

**Q: Does this plugin support exporting and importing blog posts?**
A: Yes, we have added the Blog Manager Export and Blog Manager Import features to facilitate easy export and import of blog posts.

**Q: How can I map categories between WordPress and an external API?**
A: We have introduced the Blog Categories Mapping Form, which allows you to map categories between WordPress and an external API.

## License

The Custom Fields Manager plugin is licensed under the [MIT License](LICENSE).